VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.1#0"; "COMDLG32.OCX"
Begin VB.Form frmWeight 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Weight Program"
   ClientHeight    =   4560
   ClientLeft      =   1680
   ClientTop       =   1740
   ClientWidth     =   4200
   ControlBox      =   0   'False
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "Exercise7-2.frx":0000
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   4560
   ScaleWidth      =   4200
   Begin VB.PictureBox picplot 
      BackColor       =   &H00FFFFFF&
      DrawWidth       =   2
      Height          =   2895
      Left            =   480
      ScaleHeight     =   2835
      ScaleWidth      =   3555
      TabIndex        =   6
      Top             =   1560
      Width           =   3615
   End
   Begin VB.VScrollBar vsbControl 
      Height          =   495
      Left            =   3840
      Min             =   1
      TabIndex        =   4
      Top             =   600
      Value           =   1
      Width           =   255
   End
   Begin VB.TextBox txtWeight 
      Alignment       =   2  'Center
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   2040
      TabIndex        =   3
      Top             =   600
      Width           =   1815
   End
   Begin MSComDlg.CommonDialog cdlFiles 
      Left            =   3600
      Top             =   1320
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   327681
      CancelError     =   -1  'True
   End
   Begin VB.Label lblFile 
      BackColor       =   &H0000FFFF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "New File"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   -1  'True
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   5
      Top             =   1200
      Width           =   3975
   End
   Begin VB.Label lblDate 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   120
      TabIndex        =   2
      Top             =   600
      Width           =   1815
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      Caption         =   "Weight"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   2040
      TabIndex        =   1
      Top             =   120
      Width           =   1695
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      Caption         =   "Date"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   240
      TabIndex        =   0
      Top             =   120
      Width           =   1575
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileNew 
         Caption         =   "&New"
      End
      Begin VB.Menu mnuFileOpen 
         Caption         =   "&Open"
      End
      Begin VB.Menu mnuFileSave 
         Caption         =   "&Save"
      End
      Begin VB.Menu mnuFilePlot 
         Caption         =   "&Plot"
      End
      Begin VB.Menu mnuLine 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileRecent 
         Caption         =   ""
         Index           =   0
         Visible         =   0   'False
      End
      Begin VB.Menu mnuFileRecent 
         Caption         =   ""
         Index           =   1
         Visible         =   0   'False
      End
      Begin VB.Menu mnuFileRecent 
         Caption         =   ""
         Index           =   2
         Visible         =   0   'False
      End
      Begin VB.Menu mnuFileRecent 
         Caption         =   ""
         Index           =   3
         Visible         =   0   'False
      End
      Begin VB.Menu mnuFileBar 
         Caption         =   "-"
         Visible         =   0   'False
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
End
Attribute VB_Name = "frmWeight"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim Dates(1000) As Date
Dim Weights(1000) As String
Dim NumWts As Integer
Dim NFiles As Integer, RFile(3) As String, MenuOpen As Integer, FNmenu As String

Private Sub mnuFilePlot_Click()
Dim X(100) As Integer, Y(100) As Integer
Dim I As Integer
Dim Xmin As Integer, Xmax As Integer
Dim Ymin As Integer, Ymax As Integer
Dim Legend As String
Xmin = 0: Xmax = 0
Ymin = Val(Weights(1)): Ymax = Ymin
For I = 1 To NumWts
  X(I) = DateDiff("d", Dates(1), Dates(I))
  Y(I) = Val(Weights(I))
  If X(I) < Xmin Then Xmin = X(I)
  If X(I) > Xmax Then Xmax = X(I)
  If Y(I) < Ymin Then Ymin = Y(I)
  If Y(I) > Ymax Then Ymax = Y(I)
Next I
Xmin = Xmin - 1: Xmax = Xmax + 1
Ymin = (1 - 0.05 * Sgn(Ymin)) * Ymin
Ymax = (1 + 0.05 * Sgn(Ymax)) * Ymax
picplot.Scale (Xmin, Ymax)-(Xmax, Ymin)
Cls
picplot.Cls
For I = 1 To NumWts
  picplot.Line (X(I), Ymin)-(X(I), Y(I)), QBColor(1)
Next I
Legend = Str$(Ymax)
CurrentX = picplot.Left - TextWidth(Legend)
CurrentY = picplot.Top - 0.5 * TextHeight(Legend)
Print Legend
Legend = Str$(Ymin)
CurrentX = picplot.Left - TextWidth(Legend)
CurrentY = picplot.Top + picplot.Height - 0.5 * TextHeight(Legend)
Print Legend
End Sub
Sub RFile_Update(NewFile As String)
Dim I As Integer, J As Integer, InList As Integer
'Convert name to all upper case letters
NewFile = UCase$(NewFile)
'See if file is already in list
InList = 0
For I = 0 To NFiles - 1
  If RFile(I) = NewFile Then InList = 1: Exit For
Next I

'If file not in list, increment number of items with
'a maximum of 4.  Then, move others down, then place
'new name at top of list
If InList = 0 Then
  NFiles = NFiles + 1
  If NFiles > 4 Then
    NFiles = 4
  Else
    If NFiles = 1 Then mnuFileBar.Visible = True
    mnuFileRecent(NFiles - 1).Visible = True
  End If
  If NFiles <> 1 Then
    For I = NFiles - 1 To 1 Step -1
      RFile(I) = RFile(I - 1)
    Next I
  End If
  RFile(0) = NewFile
Else
'If file already in list, put name at top and shift
'others accordingly
  If I <> 0 Then
    For J = I - 1 To 0 Step -1
      RFile(J + 1) = RFile(J)
    Next J
    RFile(0) = NewFile
  End If
End If

'Set menu captions according to new list
For I = 0 To NFiles - 1
  mnuFileRecent(I).Caption = "&" + Format(I + 1, "# ") + RFile(I)
Next I

End Sub





Sub Init()
NumWts = 1:  vsbControl.Value = 1: vsbControl.Max = 1
Dates(1) = Format(Now, "mm/dd/yy")
Weights(1) = ""
lblDate.Caption = Dates(1)
txtWeight.Text = Weights(1)
lblFile.Caption = "New File"
End Sub

Private Sub Form_Load()
Dim I As Integer
'Open .ini file and load in recent file names
Open "weight.ini" For Input As #1
NFiles = 0: MenuOpen = 0
For I = 0 To 3
  Input #1, RFile(I)
  If RFile(I) <> "" Then
    NFiles = NFiles + 1
    mnuFileBar.Visible = True
    mnuFileRecent(I).Caption = "&" + Format(I + 1, "# ") + RFile(I)
    mnuFileRecent(I).Visible = True
  End If
Next I
Close 1
frmWeight.Show
Call Init
End Sub

Private Sub mnuFileExit_Click()
'Make sure user really wants to exit
Dim Response As Integer, I As Integer
Response = MsgBox("Are you sure you want to exit the weight program?", vbYesNo + vbCritical + vbDefaultButton2, "Exit Editor")
If Response = vbNo Then
  Exit Sub
Else
  Open "weight.ini" For Output As #1
  For I = 0 To 3
    Write #1, RFile(I)
  Next I
  Close 1
  End
End If
End Sub

Private Sub mnuFileNew_Click()
'User wants new file
Dim Response As Integer
Response = MsgBox("Are you sure you want to start a new file?", vbYesNo + vbQuestion, "New File")
If Response = vbNo Then
  Exit Sub
Else
  Call Init
End If
End Sub



Private Sub mnuFileOpen_Click()
Dim I As Integer
Dim Today As Date
Dim Response As Integer
Dim File_To_Open As String
Response = MsgBox("Are you sure you want to open a new file?", vbYesNo + vbQuestion, "New File")
If Response = vbNo Then Exit Sub
If MenuOpen = 0 Then
  cdlFiles.Filter = "Files (*.wgt)|*.wgt"
  cdlFiles.DefaultExt = "wgt"
  cdlFiles.DialogTitle = "Open File"
  cdlFiles.Flags = cdlOFNFileMustExist + cdlOFNPathMustExist
  On Error GoTo No_Open
  cdlFiles.ShowOpen
  File_To_Open = cdlFiles.filename
Else
  File_To_Open = FNmenu
End If
MenuOpen = 0
On Error GoTo BadOpen
Open File_To_Open For Input As #1
lblFile.Caption = File_To_Open
Input #1, NumWts
For I = 1 To NumWts
  Input #1, Dates(I), Weights(I)
Next I
Close 1
Call RFile_Update(File_To_Open)
Today = Format(Now, "mm/dd/yy")
If Today <> Dates(NumWts) Then
  NumWts = NumWts + 1
  Dates(NumWts) = Today
  Weights(NumWts) = ""
End If
vsbControl.Max = NumWts
vsbControl.Value = NumWts
lblDate.Caption = Dates(NumWts)
txtWeight.Text = Weights(NumWts)
Exit Sub
No_Open:
Resume ExitLine
ExitLine:
Exit Sub
BadOpen:
Select Case MsgBox(Error$(Err.Number), vbCritical + vbRetryCancel, "File Open Error")
Case vbRetry
  Resume
Case vbCancel
  Resume No_Open
End Select
End Sub

Private Sub mnuFileRecent_Click(Index As Integer)
  FNmenu = RFile(Index): MenuOpen = 1
  Call mnuFileOpen_Click
End Sub

Private Sub mnuFileSave_Click()
Dim I As Integer
cdlFiles.Filter = "Files (*.wgt)|*.wgt"
cdlFiles.DefaultExt = "wgt"
cdlFiles.DialogTitle = "Save File"
cdlFiles.Flags = cdlOFNOverwritePrompt + cdlOFNPathMustExist
On Error GoTo No_Save
cdlFiles.ShowSave
Open cdlFiles.filename For Output As #1
lblFile.Caption = cdlFiles.filename
Write #1, NumWts
For I = 1 To NumWts
  Write #1, Dates(I), Weights(I)
Next I
Close 1
Call RFile_Update(cdlFiles.filename)
Exit Sub
No_Save:
Resume ExitLine
ExitLine:
Exit Sub
End Sub











Private Sub txtWeight_Change()
Weights(vsbControl.Value) = txtWeight.Text
End Sub


Private Sub txtWeight_KeyPress(KeyAscii As Integer)
If KeyAscii >= vbKey0 And KeyAscii <= vbKey9 Then
  Exit Sub
Else
  KeyAscii = 0
End If
End Sub


Private Sub vsbControl_Change()
lblDate.Caption = Dates(vsbControl.Value)
txtWeight.Text = Weights(vsbControl.Value)
txtWeight.SetFocus
End Sub


